import pickle
import numpy as np
import pandas as pd
from PIL import Image
from skimage.metrics import structural_similarity
import imageio

def compare_values(ai_output, reference_output):  
    # Compare p-values  
    value_equal = np.isclose(ai_output, reference_output)  
    
    return value_equal


def compare_series(ai_output, reference_output):  
  
    # Compare correlation matrices  
    corr_matrix_equal = np.allclose(ai_output, reference_output)  
    
    return corr_matrix_equal
    
    
def compare_plots(ai_output, reference_output):  
    # Load the images  
    image1 = Image.open(ai_output)  
    image2 = Image.open(reference_output)  
    
    # Define the new size (width, height)  
    new_size = (800, 600)  
    
    # Resize the images  
    resized_image1 = image1.resize(new_size, Image.Resampling.LANCZOS)  
    resized_image2 = image2.resize(new_size, Image.Resampling.LANCZOS)  
    
    # Save the resized images  
    resized_image1.save("resized_plot1.png")  
    resized_image2.save("resized_plot2.png")  

    image1 = imageio.imread("resized_plot1.png", mode='L')  
    image2 = imageio.imread("resized_plot2.png", mode='L')  
    
    ssim = structural_similarity(image1, image2, data_range=1)  
    
    return ssim


# Replace <ai_res> and <ref_res> with the actual AI and reference outputs
try:
    with open("pred_result/age_mean.pkl", "rb") as fp:
        machine_result = pickle.load(fp)
except:
        machine_result = None

with open("ref_result/age_mean.pkl", "rb") as fr:
    reference_result = pickle.load(fr)

# Call the satisfies_user_requirements function with both outputs
try:
    result = compare_values(machine_result, reference_result)
except:
    result = False

print(result)

# Replace <ai_res> and <ref_res> with the actual AI and reference outputs
try:
    with open("pred_result/age_median.pkl", "rb") as fp:
        machine_result = pickle.load(fp)
except:
        machine_result = None

with open("ref_result/age_median.pkl", "rb") as fr:
    reference_result = pickle.load(fr)

# Call the satisfies_user_requirements function with both outputs
try:
    result = compare_values(machine_result, reference_result)
except:
    result = False

print(result)

# Replace <ai_res> and <ref_res> with the actual AI and reference outputs
try:
    with open("pred_result/age_mode.pkl", "rb") as fp:
        machine_result = pickle.load(fp)
except:
        machine_result = None

with open("ref_result/age_mode.pkl", "rb") as fr:
    reference_result = pickle.load(fr)

# Call the satisfies_user_requirements function with both outputs
try:
    result = compare_values(machine_result, reference_result)
except:
    result = False

print(result)

# Replace <ai_res> and <ref_res> with the actual AI and reference outputs
try:
    with open("pred_result/age_range.pkl", "rb") as fp:
        machine_result = pickle.load(fp)
except:
        machine_result = None

with open("ref_result/age_range.pkl", "rb") as fr:
    reference_result = pickle.load(fr)

# Call the satisfies_user_requirements function with both outputs
try:
    result = compare_values(machine_result, reference_result)
except:
    result = False

print(result)

# Replace <ai_res> and <ref_res> with the actual AI and reference outputs
try:
    with open("pred_result/credit_history_counts.pkl", "rb") as fp:
        machine_result = pickle.load(fp)
except:
        machine_result = None

with open("ref_result/credit_history_counts.pkl", "rb") as fr:
    reference_result = pickle.load(fr)

# Call the satisfies_user_requirements function with both outputs
try:
    result = compare_series(machine_result, reference_result)
except:
    result = False

print(result)

# Replace <ai_res> and <ref_res> with the actual AI and reference outputs
try:
    with open("pred_result/employment_counts.pkl", "rb") as fp:
        machine_result = pickle.load(fp)
except:
        machine_result = None

with open("ref_result/employment_counts.pkl", "rb") as fr:
    reference_result = pickle.load(fr)

# Call the satisfies_user_requirements function with both outputs
try:
    result = compare_series(machine_result, reference_result)
except:
    result = False

print(result)

# Replace <ai_res> and <ref_res> with the actual AI and reference outputs
machine_result = "pred_result/countplot_2.png"

reference_result = "ref_result/countplot_2.png"
  
# Call the compare_plots function with both outputs
try:
    result = compare_plots(machine_result, reference_result)
except:
    result = False

print(result)

# Replace <ai_res> and <ref_res> with the actual AI and reference outputs
machine_result = "pred_result/countplot.png"

reference_result = "ref_result/countplot.png"
  
# Call the compare_plots function with both outputs
try:
    result = compare_plots(machine_result, reference_result)
except:
    result = False

print(result)

# Replace <ai_res> and <ref_res> with the actual AI and reference outputs
machine_result = "pred_result/histplot.png"

reference_result = "ref_result/histplot.png"
  
# Call the compare_plots function with both outputs
try:
    result = compare_plots(machine_result, reference_result)
except:
    result = False

print(result)

